/********************************************************************************//**
 *
 * @file		LCD_16x2.h
 *
 ************************************************************************************
 *
 * @brief		
 *
 * @details		
 *
 * @note		
 *
 * @date		Aug 8, 2013
 * @author		dujalan
 * @version		
 * @copyright	Shalaka Technologies Pvt. Ltd.
 *
 ************************************************************************************
 ***********************************************************************************/

#ifndef LCD_16X2_H_
#define LCD_16X2_H_


/*===================================================================================
									Include Files
===================================================================================*/

#include <stdbool.h>
#include <stdint.h>
#include <string.h>


/*===================================================================================
									Pin Definitions
===================================================================================*/

/*! 4BIT/8BIT MODE */
//#define LCD_4BIT
#define LCD_8BIT


#define LCD_CONTROL_PORT			GPIO_PORTF_BASE
#define LCD_CONTROL_PORT_ENABLE		SYSCTL_PERIPH_GPIOF
#define RS							GPIO_PIN_5
#define EN							GPIO_PIN_6
// RW is directly grounded as we would only be writing to the LCD


#ifdef LCD_4BIT
	#define LCD_DATA_PORT				GPIO_PORTB_BASE
	#define LCD_DATA_PORT_ENABLE		SYSCTL_PERIPH_GPIOB

	#define D4							GPIO_PIN_4
	#define D5							GPIO_PIN_5
	#define D6							GPIO_PIN_6
	#define D7							GPIO_PIN_7
#elif defined(LCD_8BIT)
	#define LCD_DATA_PORT				GPIO_PORTB_BASE
	#define LCD_DATA_PORT_ENABLE		SYSCTL_PERIPH_GPIOB

	#define D0							GPIO_PIN_0
	#define D1							GPIO_PIN_1
	#define D2							GPIO_PIN_2
	#define D3							GPIO_PIN_3
	#define D4							GPIO_PIN_4
	#define D5							GPIO_PIN_5
	#define D6							GPIO_PIN_6
	#define D7							GPIO_PIN_7
#endif


/*===================================================================================
									Macro Definitions
===================================================================================*/

/*!
 ************************************************************************************
 * @name	Main Functions
 * @{
 ************************************************************************************
 */

#define LCD_CLEARDISPLAY	0x01
#define LCD_RETURNHOME		0x02
#define LCD_ENTRYMODESET	0x04
#define LCD_DISPLAYCONTROL	0x08
#define LCD_CURSORSHIFT		0x10
#define LCD_FUNCTIONSET		0x20
#define LCD_SETCGRAMADDR	0x40
#define LCD_SETDDRAMADDR	0x80

/*!
 ************************************************************************************
 * @}
 ************************************************************************************
 */		// End of Main Functions


/*!
 ************************************************************************************
 * @name	Flags for Display Entry Mode
 * @{
 ************************************************************************************
 */

#define LCD_ENTRYRIGHT				0x00
#define LCD_ENTRYLEFT				0x02
#define LCD_ENTRYSHIFTINCREMENT		0x01
#define LCD_ENTRYSHIFTDECREMENT		0x00

/*!
 ************************************************************************************
 * @}
 ************************************************************************************
 */		// End of Flags for Display Entry Mode


/*!
 ************************************************************************************
 * @name	Flags for Display On/Off Control
 * @{
 ************************************************************************************
 */

#define LCD_DISPLAYON		0x04
#define LCD_DISPLAYOFF		0x00
#define LCD_CURSORON		0x02
#define LCD_CURSOROFF		0x00
#define LCD_BLINKON			0x01
#define LCD_BLINKOFF		0x00

/*!
 ************************************************************************************
 * @}
 ************************************************************************************
 */		// End of Flags for Display On/Off Control


/*!
 ************************************************************************************
 * @name	Flags for Display/Cursor Shift
 * @{
 ************************************************************************************
 */

#define LCD_DISPLAYMOVE		0x08
#define LCD_CURSORMOVE		0x00
#define LCD_MOVERIGHT		0x04
#define LCD_MOVELEFT		0x00

/*!
 ************************************************************************************
 * @}
 ************************************************************************************
 */		// End of Flags for Display/Cursor Shift


/*!
 ************************************************************************************
 * @name	Flags for Function Set
 * @{
 ************************************************************************************
 */

#define LCD_8BITMODE		0x10
#define LCD_4BITMODE		0x00
#define LCD_2LINE			0x08
#define LCD_1LINE			0x00
#define LCD_5x10DOTS		0x04
#define LCD_5x8DOTS			0x00

/*!
 ************************************************************************************
 * @}
 ************************************************************************************
 */		// End of Flags for Function Set


/*===================================================================================
								Function Declarations
===================================================================================*/

/*!
 ************************************************************************************
 * @name	LCD_16x2 API Functions
 * @{
 ************************************************************************************
 */

void delayS(unsigned int time);
void LCDInit(void);
void LCDSendEnable(void);
void LCDSendCommand(char inCommand);
void LCDSendChar(char inChar);
void LCDSendString(char *inString, char inRow, char inColumn);

/*!
 ************************************************************************************
 * @}
 ************************************************************************************
 */		// End of LCD_16x2 API Functions


#endif /* LCD_16X2_H_ */
